import { Request, Response } from 'express';
import { shoppingListService } from './service';

export const shoppingListController = {
  // POST /shopping-lists
  async createShoppingList(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor) return res.status(401).json({ error: 'Unauthorized' });
    const { name, notes, items } = req.body;
    const { data, error } = await shoppingListService.createShoppingList(vendor.id, name, notes, items);
    if (error) return res.status(400).json({ error: error.message });
    return res.status(201).json({ success: true, data });
  },

  // GET /shopping-lists/:id/match-sellers
  async matchSellers(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor) return res.status(401).json({ error: 'Unauthorized' });
    const { id } = req.params;
    const { data, error } = await shoppingListService.matchSellersForList(id);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // POST /orders
  async createOrder(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor) return res.status(401).json({ error: 'Unauthorized' });
    const { shopping_list_id, seller_id, items } = req.body;
    const { data, error } = await shoppingListService.createOrder(vendor.id, shopping_list_id, seller_id, items);
    if (error) return res.status(400).json({ error: error.message });
    return res.status(201).json({ success: true, data });
  },

  // GET /orders
  async getOrders(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor) return res.status(401).json({ error: 'Unauthorized' });
    const { status } = req.query;
    const { data, error } = await shoppingListService.getOrders(vendor.id, status);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // PATCH /orders/:id
  async updateOrderStatus(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor) return res.status(401).json({ error: 'Unauthorized' });
    const { id } = req.params;
    const { status } = req.body;
    const { data, error } = await shoppingListService.updateOrderStatus(id, vendor.id, status);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  }
}; 